% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_distrib_histo.R
\name{f_distrib_histo}
\alias{f_distrib_histo}
\title{Historical distributions}
\usage{
f_distrib_histo(
  qt_trgt,
  v_dep,
  v_expl,
  type_function,
  starting_values,
  step,
  x_min,
  x_max
)
}
\arguments{
\item{qt_trgt}{Numeric vector, dim k, of k quantiles for different qt-estimations}

\item{v_dep}{Numeric vector of the dependent variable}

\item{v_expl}{Numeric vector of the (k) explanatory variable(s)}

\item{type_function}{String argument : "gaussian" for normal distribution or "skew-t" for t-student distribution}

\item{starting_values}{Numeric vector with initial values for optimization}

\item{step}{Numeric argument for accuracy graphics abscissa}

\item{x_min}{Numeric optional argument (default value = -15)}

\item{x_max}{Numeric optional argument (default value = 10)}
}
\value{
A list with:
\item{distrib_histo}{Numeric matrix with historical values of x, y and t}
\item{param_histo}{Numeric matrix containing the parameters of the distribution for each period}
}
\description{
This function is based on f_distrib function (Adrian et al., 2019; Adrian et al., 2022) and is used to get historical estimation of empirical distributions and associated parameters. Results allow to realize a 3D graphical representation.
}
\examples{
\donttest{# Import data
data("data_euro")

# Data process
PIB_euro_forward_4 = data_euro["GDP"][c(5:length(data_euro["GDP"][,1])),]
FCI_euro_lag_4 = data_euro["FCI"][c(1:(length(data_euro["GDP"][,1]) - 4)),]
CISS_euro_lag_4 = data_euro["CISS"][c(1:(length(data_euro["GDP"][,1]) - 4)),]

results_histo <- f_distrib_histo(qt_trgt=c(0.10,0.25,0.75,0.90), v_dep=PIB_euro_forward_4,
v_expl=cbind(FCI_euro_lag_4,CISS_euro_lag_4),
type_function="skew-t",
starting_values=c(0, 1, -0.5, 1.3),
step=5, x_min=-10, x_max=5)

library(plot3D) # load
scatter3D(results_histo$distrib_histo[,3],
results_histo$distrib_histo[,1],
results_histo$distrib_histo[,2],
pch = 10,  theta = 70, phi = 10,
main = "Distribution of GDP Growth over time - Euro Area",
xlab = "Date",
ylab ="Pib",
zlab="", cex = 0.3)}
}
\references{
Adrian, Tobias, Nina Boyarchenko, and Domenico Giannone. "Vulnerable growth." American Economic Review 109.4 (2019): 1263-89.

Adrian, Tobias, et al. "The term structure of growth-at-risk." American Economic Journal: Macroeconomics 14.3 (2022): 283-323.
}
