% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b.miph.MoE.R
\name{MoE,mph-method}
\alias{MoE,mph-method}
\title{Fit method for mph/miph class, using mixture-of-experts regression}
\usage{
\S4method{MoE}{mph}(
  x,
  formula,
  y,
  data,
  alpha_mat = NULL,
  delta = numeric(0),
  stepsEM = 1000,
  r = 1,
  maxit = 100,
  reltol = 1e-08,
  rand_init = T
)
}
\arguments{
\item{x}{An object of class \linkS4class{mph}.}

\item{formula}{a regression formula.}

\item{y}{A matrix of observations.}

\item{data}{A data frame of covariates (they need to be scaled for the regression).}

\item{alpha_mat}{Matrix with initial distribution vectors for each row of observations.}

\item{delta}{Matrix with right-censoring indicators (1 uncensored, 0 right censored).}

\item{stepsEM}{Number of EM steps to be performed.}

\item{r}{Sub-sampling parameter, defaults to 1 (not supported for this method).}

\item{maxit}{Maximum number of iterations when optimizing the g function (inhomogeneous likelihood).}

\item{reltol}{Relative tolerance when optimizing g function.}

\item{rand_init}{Random initiation in the R-step of the EM algorithm.}
}
\description{
Fit method for mph/miph class, using mixture-of-experts regression
}
\examples{
under_mph <- mph(structure = c("general", "general"), dimension = 3) 
x <-  miph(under_mph, gfun = c("weibull", "weibull"), gfun_pars = list(c(2), c(3)))
n <- 100
responses <- cbind(rexp(n), rweibull(n, 2, 3))
covariates <- data.frame(age = sample(18:65, n, replace = TRUE) / 100, income = runif(n, 0, 0.99))
f <- responses ~ age + income
MoE(x = x, formula = f, y = responses, data = covariates, stepsEM = 20)
}
