#' Display package version for \pkg{matriz}
#'
#' @description \code{matriz_message()} produces a message about the package version
#' and the version of R making use of this package.
#'
#' @return \code{dmatriz_message()} returns a message about the install version
#' of \pkg{matriz}.
#' @export
#'
#' @author JP Monteagudo
#'
#' @examples
#' matriz_message()
#'
#'
matriz_message <- function(){
  cat("-------------------------\n")
  message(paste0("matriz string generated by {matriz} v.",
                 utils::packageVersion("matriz"), ".\n",
                 R.Version()$version.string, "."))
  cat("-------------------------\n")
  cat("Easily generate and manage structured literature review matrices in R.\n")
  cat("Streamline your research synthesis, track key study details, and organize citations efficiently.\n")
}

