% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxbootr.R
\name{maxbootr}
\alias{maxbootr}
\title{Bootstrap Estimation for Block Maxima}
\usage{
maxbootr(
  xx,
  est,
  block_size,
  B = 1000,
  type = "sb",
  seed = 1,
  p = NULL,
  annuity = NULL
)
}
\arguments{
\item{xx}{A numeric vector or array containing univariate samples. For multivariate cases, samples should be arranged in rows.}

\item{est}{A string specifying the estimator to apply. Must be one of \code{"mean"}, \code{"var"}, \code{"gev"}, \code{"quantile"}, or \code{"rl"}.}

\item{block_size}{Integer. Size of each block used in the block maxima extraction.}

\item{B}{Integer. Number of bootstrap replicates to generate.}

\item{type}{Type of block bootstrapping: \code{"db"} for disjoint blocks or \code{"sb"} for sliding blocks (internally approximated via circular blocks).}

\item{seed}{Integer. Seed for reproducibility.}

\item{p}{Optional numeric value in (0,1). Required if \code{est = "quantile"}.}

\item{annuity}{Optional numeric value > 1. Required if \code{est = "rl"} for return level estimation.}
}
\value{
A numeric vector with \code{B} rows for scalar estimators. If \code{est = "gev"}, a matrix with \code{B} rows is returned. Each row contains 3 estimated GEV parameters (location, scale, shape).
}
\description{
Performs bootstrap resampling for various block maxima estimators (mean, variance, GEV parameters, quantile, return level) using either disjoint or sliding block methods.
}
\examples{
if (requireNamespace("maxbootR", quietly = TRUE)) {
  library(maxbootR)
  set.seed(123)
  x <- rnorm(100)

  # Bootstrap mean using sliding blocks
  boot_mean <- maxbootr(x, est = "mean", block_size = 10, B = 20, type = "sb")

  # Bootstrap variance using disjoint blocks
  boot_var <- maxbootr(x, est = "var", block_size = 10, B = 20, type = "db")

  # Bootstrap 95\%-quantile of block maxima using sliding blocks
  boot_q <- maxbootr(x, est = "quantile", block_size = 10, B = 20, type = "db", p = 0.95)
}
}
