% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_grid_to_polygons.R
\name{aggregate_draws_to_polygons_validation}
\alias{aggregate_draws_to_polygons_validation}
\title{Aggregate grid cell draws to polygons: validation}
\usage{
aggregate_draws_to_polygons_validation(
  draws_matrix,
  aggregation_table,
  aggregation_cols,
  method,
  z_dimension,
  z_dimension_name,
  weighting_raster,
  na.rm
)
}
\arguments{
\item{draws_matrix}{\code{matrix}, \code{array}, or \code{data.frame} corresponding to grid cell draws
that will be aggregated to polygons.}

\item{aggregation_table}{\link[data.table:data.table]{data.table::data.table} Aggregation table linking pixels to
polygon identifiers, created using \code{build_aggregation_table()}}

\item{aggregation_cols}{(character vector, default 'polygon_id') Polygon identifiers
to use for aggregation.}

\item{method}{(character, default 'mean') Aggregation method: one of 'mean', 'sum',
'weighted.mean', or 'weighted.sum'.}

\item{z_dimension}{(vector, default NULL) If passing a \code{draws_matrix} with multiple
sets of estimates, how should each layer be identified?}

\item{z_dimension_name}{(default 'z') The field name for the "z" dimension
corresponding to each set of estimates contained in \code{draws_matrix}.}

\item{weighting_raster}{(\link[terra:SpatRaster-class]{terra::SpatRaster}, default NULL) The relative weighting of
each whole pixel to the overall polygon value, for example, if calculating a
population-weighted mean.}

\item{na.rm}{(bool, default TRUE) How to handle NA values in \code{draws_matrix} and
\code{weighting_raster}.}
}
\value{
Errors if checks fail; silently passes if checks pass
}
\description{
Data validation for aggregate_draws_to_polygons
}
\seealso{
aggregate_draws_to_polygons
}
\keyword{internal}
