% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-balance-optim.R
\name{back_trans}
\alias{back_trans}
\title{Back-transformation}
\usage{
back_trans(hat, years, mus, sigmas, log.trans, N, season.names)
}
\arguments{
\item{hat}{A vector of estimated flow in the transformed space.}

\item{years}{A vector of all years in the study period}

\item{mus}{A vector of means, one for each target.}

\item{sigmas}{A vector of the standard deviations, one for each target.}

\item{log.trans}{A vector containing the indices of the columns to be log-transformed.}

\item{N}{The number of targets (number of seasons plus one for the annual reconstruction).}

\item{season.names}{A character vector containing the names of the seasons}
}
\value{
A \code{data.table} with three columns: Q (the back-transformed streamflow), season, and year.
}
\description{
Transform the reconstructed values back to the flow space
and convert to data.table
}
