% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass-balance-optim.R
\name{cv_mb}
\alias{cv_mb}
\title{Cross-validation}
\usage{
cv_mb(
  instQ,
  pc.list,
  cv.folds,
  start.year,
  lambda = 1,
  log.trans = NULL,
  force.standardize = FALSE,
  return.type = c("fval", "metrics", "metric means", "Q")
)
}
\arguments{
\item{instQ}{Instrumental data, in the same order as pc.list. The "season" column must be a factor.}

\item{pc.list}{List of PC matrices}

\item{cv.folds}{A list containing the cross validation folds}

\item{start.year}{The first year of record}

\item{lambda}{The penalty weight}

\item{log.trans}{A vector containing indices of the targets to be log-transformed. If no transformation is needed, provide \code{NULL}.}

\item{force.standardize}{If TRUE, all observations are standardized. See Details.}

\item{return.type}{The type of results to be returned. Several types are possible to suit multiple use cases.
\describe{
\item{\code{fval}}{Only the objective function value (penalized least squares) is returned; this is useful for the outer optimization for site selection.}
\item{\code{metrics}}{all performance metrics are returned.}
\item{\verb{metric means}}{the Tukey's biweight robust mean of each metric is returned.}
\item{\code{Q}}{The predicted flow in each cross-validation run is returned. This is the most basic output, so that you can use it to calculate other metrics that are not provided by the package.}
}}
}
\value{
A \code{data.table} containing cross-validation results (metrics, fval, or metric means) for each target.
}
\description{
Cross-validation
}
\examples{
cvFolds <- make_Z(1922:2003, nRuns = 50, frac = 0.25, contiguous = TRUE)
cv <- cv_mb(p1Seasonal, pc3seasons, cvFolds, 1750, log.trans = 1:3, return.type = 'metrics')
}
