% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcMSTEmoaBG.R
\name{mcMSTEmoaBG}
\alias{mcMSTEmoaBG}
\title{Subgraph EMOA for the multi-criteria MST problem.}
\usage{
mcMSTEmoaBG(
  instance,
  mu,
  lambda = mu,
  mut = NULL,
  selMating = NULL,
  selSurvival = ecr::selNondom,
  ref.point = NULL,
  max.iter = 100L,
  ...
)
}
\arguments{
\item{instance}{[\code{\link[grapherator]{grapherator}}]\cr
Multi-objective graph.}

\item{mu}{[\code{integer(1)}]\cr
Population size.}

\item{lambda}{[\code{integer(1)}]\cr
Number of offspring generated in each generation.
Default is \code{mu}.}

\item{mut}{[\code{ecr_mutator}]\cr
Mutation operator.
Default is \code{\link{mutSubgraphMST}}.}

\item{selMating}{[\code{ecr_selector}]\cr
Mating selector.
Default is \code{\link[ecr]{selSimple}}.}

\item{selSurvival}{[\code{ecr_selector}]\cr
Survival selector.
Default is \code{link[ecr]{selNondom}}.}

\item{ref.point}{[\code{numeric(n.objectives) | NULL}]\cr
Reference point for hypervolume computation used for logging.
If \code{NULL} the sum of the \eqn{n} largest edges in each objective
is used where \eqn{n} is the number of nodes of \code{instance}.
This is an upper bound for the size of each spanning tree
with \eqn{(n-1)} edges.}

\item{max.iter}{[\code{integer(1)}]\cr
Maximal number of iterations.
Default is \code{100}.}

\item{...}{[\code{any}]\cr
Further parameters passed to mutator.}
}
\value{
[\code{\link[ecr]{ecr_result}}] List of type \code{\link[ecr]{ecr_result}}
 with the following components:
 \describe{
  \item{task}{The \code{ecr_optimization_task}.}
  \item{log}{Logger object.}
  \item{pareto.idx}{Indizes of the non-dominated solutions in the last population.}
  \item{pareto.front}{(n x d) matrix of the approximated non-dominated front where n
  is the number of non-dominated points and d is the number of objectives.}
  \item{pareto.set}{Matrix of decision space values resulting with objective values
  given in pareto.front.}
  \item{last.population}{Last population.}
  \item{message}{Character string describing the reason of termination.}
 }
}
\description{
Evolutionary multi-objective algorithm to solve the
multi-objective minimum spanning tree problem. The algorithm relies
to mutation only to generate offspring. The package contains the subgraph mutator
(see \code{\link{mutSubgraphMST}}) or a simple one-edge exchange mutator
(see \code{\link{mutEdgeExchange}}). Of course, the user may use any
custom mutator which operators on edge lists as well
(see \code{\link[ecr]{makeMutator}}).
}
\examples{
inst = genRandomMCGP(10)
res = mcMSTEmoaBG(inst, mu = 20L, max.iter = 100L)
print(res$pareto.front)
print(tail(getStatistics(res$log)))
}
\references{
Bossek, J., and Grimme, C. A Pareto-Beneficial Sub-Tree Mutation
for the Multi-Criteria Minimum Spanning Tree Problem. In Proceedings of the
2017 IEEE Symposium Series on Computational Intelligence (2017). (accepted)
}
\seealso{
Mutators \code{\link{mutSubgraphMST}} and \code{\link{mutEdgeExchange}}

Other mcMST EMOAs: 
\code{\link{mcMSTEmoaZhou}()}

Other mcMST algorithms: 
\code{\link{mcMSTEmoaZhou}()},
\code{\link{mcMSTPrim}()}
}
\concept{mcMST EMOAs}
\concept{mcMST algorithms}
