% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa_operators.R
\name{mutSubgraphMST}
\alias{mutSubgraphMST}
\title{Subgraph-mutator for edge list representation.}
\usage{
mutSubgraphMST(
  ind,
  sigma = floor(ncol(ind)/2),
  scalarize = FALSE,
  instance = NULL
)
}
\arguments{
\item{ind}{[\code{matrix(2, m)}]\cr
Matrix of edges (each column is one edge).}

\item{sigma}{[\code{integer()}]\cr
Upper bound for the size of the selected subtree.}

\item{scalarize}{[\code{logical(1)}]\cr
Should a scalarized version of the the subproblem be solved?
If \code{TRUE}, a random weight \eqn{\lambda \in [0,1]} is sampled
from a \code{U[0, 1]}-distribution. Next, a weighted sum
scalarization \eqn{\lambda \cdot c_1 + (1 - \lambda) \cdot c_2}
of the subproblem is solved.
Default is \code{FALSE}, i.e., the single-objective subproblem is
solved. The objective to optimize for is sampled with equal probability.}

\item{instance}{[\code{\link[grapherator]{grapherator}}]\cr
Multi-objective graph.}
}
\value{
[\code{matrix(2, m)}] Mutated edge list.
}
\description{
\code{mutSubgraphMST} selects a random edge e = (u, v) and traverses
the tree starting form u and v respectively until a connected subtree of at most
\code{sigma} edges is selected. Then the subtree is replaced with the optimal spanning subtree
regarding one of the objectives with equal probability.
}
\seealso{
Evolutionary multi-objective algorithm \code{\link{mcMSTEmoaBG}}

Other mcMST EMOA mutators: 
\code{\link{mutEdgeExchange}()},
\code{\link{mutKEdgeExchange}()},
\code{\link{mutSubforestMST}()},
\code{\link{mutUniformPruefer}()}
}
\concept{mcMST EMOA mutators}
