% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CtsHypothesisTests.R
\name{showXtremeEventsCts}
\alias{showXtremeEventsCts}
\title{Highlight extreme events}
\usage{
showXtremeEventsCts(
  testID,
  testStat,
  densFun,
  degFree = NULL,
  degFree1 = NULL,
  degFree2 = NULL,
  xlims,
  verbose = 1,
  ...
)
}
\arguments{
\item{testID}{name of hypothesis test}

\item{testStat}{test statistic}

\item{densFun}{function that computes appropriate density}

\item{degFree}{degrees of freedom when only one is needed. This gets passed into densFun}

\item{degFree1}{first degrees of freedom parameter when more than one is needed}

\item{degFree2}{second degrees of freedom parameter when more than one is needed}

\item{xlims}{x limits of the graph to be used. This is passed to ggplot}

\item{verbose}{if verbose > 0 the resulting graph is printed}

\item{...}{extra arguments passed to density function}
}
\value{
results of call testFun
}
\description{
Make graph highlighting events more extreme than observed sample
}
\examples{
x <- rnorm(100)
showT.Test(x, verbose = 0)
showT.Test(x)

}
