% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_ess.R
\name{ESS}
\alias{ESS}
\title{Generalized Error Sum of Squares}
\source{
Bonat, W. H. (2018). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, 84(4):1--30.

Wang, M. (2014). Generalized Estimating Equations in Longitudinal Data
Analysis: A Review and Recent Developments. Advances in Statistics, 1(1)1--13.
}
\usage{
ESS(object, verbose = TRUE)
}
\arguments{
\item{object}{an object or a list of objects representing a model
of \code{mcglm} class.}

\item{verbose}{logical. Print or not the ESS value.}
}
\value{
An invisible list with a single numeric component:
\describe{
  \item{ESS}{The generalized error sum of squares, scaled by the residual
  degrees of freedom.}
}
}
\description{
Extract the generalized error sum of squares (ESS) for
objects of \code{mcglm} class.
}
\seealso{
\code{gof}, \code{plogLik}, \code{pAIC}, \code{pKLIC},
\code{GOSHO} and \code{RJC}.
}
\author{
Wagner Hugo Bonat, \email{wbonat@ufpr.br}
}
