% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_sic.R
\name{mc_sic}
\alias{mc_sic}
\title{Score Information Criterion for Regression Components}
\usage{
mc_sic(object, scope, data, response, penalty = 2, weights)
}
\arguments{
\item{object}{An object of class \code{mcglm}.}

\item{scope}{A character vector with the names of covariates to be tested for
inclusion in the linear predictor.}

\item{data}{A data frame containing all variables involved in the model.}

\item{response}{An integer indicating the response variable for which the SIC is
computed.}

\item{penalty}{A numeric penalty term applied to the SIC (default is 2).}

\item{weights}{An optional numeric vector of weights used in model fitting. If not
provided, unit weights are assumed.}
}
\value{
A data frame with the following columns:
\describe{
  \item{SIC}{Score Information Criterion value.}
  \item{Covariates}{Name of the candidate covariate.}
  \item{df}{Degrees of freedom associated with the test.}
  \item{df_total}{Total number of regression parameters in the extended model.}
  \item{Tu}{Score-based test statistic.}
  \item{Chisq}{Reference chi-squared quantile with 95\% confidence level.}
}
}
\description{
Computes the Score Information Criterion (SIC) for regression
components of a fitted \code{mcglm} object. The SIC can be used for
selecting covariates in the linear predictor and supports stepwise
selection procedures.
}
\details{
The SIC is computed using the quasi-score function associated with the
regression parameters. For each candidate covariate in \code{scope},
the method evaluates its contribution via a score-based test statistic
and applies a penalty for model complexity.
}
\examples{
set.seed(123)
x1 <- runif(100, -1, 1)
x2 <- gl(2, 50)
beta <- c(5, 0, 3)
X <- model.matrix(~ x1 + x2)
y <- rnorm(100, mean = X \%*\% beta, sd = 1)
data <- data.frame(y, x1, x2)

Z0 <- mc_id(data)
fit0 <- mcglm(
  linear_pred = c(y ~ 1),
  matrix_pred = list(Z0),
  data = data
)

mc_sic(fit0, scope = c("x1", "x2"), data = data, response = 1)

}
\references{
Bonat, W. H. (2018). Multiple Response Variables Regression Models in R:
The mcglm Package. \emph{Journal of Statistical Software}, 84(4), 1--30.

Bonat, W. H., et al. (2016). Modelling the covariance structure in
marginal multivariate count models: Hunting in Bioko Island.
\emph{Journal of Agricultural, Biological and Environmental Statistics},
22(4), 446--464.
}
\seealso{
\code{\link{mc_sic_covariance}}
}
