% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypvolgmm.R
\name{hypvolgmm_hdlevel}
\alias{hypvolgmm_hdlevel}
\title{Default HDR level defining the GMM hull}
\usage{
hypvolgmm_hdlevel(dens, ...)
}
\arguments{
\item{dens}{A vector of density estimates for the \eqn{n} observed data points.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns a list containing the following elements:
\itemize{
\item \code{alpha} A vector of alpha values specifying the HDR levels.
\item \code{h_alpha} A vector of HDR density values corresponding to \code{alpha}.
\item \code{pcwsreg} The two-segment piecewise linear regression model.
\item \code{hdl}	The optimal HDR level selected as the change-point value.
\item \code{h}	The HDR density values corresponding to the optimal HDR level.
}
}
\description{
Compute default HDR level used to define the GMM hull. This is obtained by
fitting a two-segment piecewise linear regression model (i.e., single change
point model) to a grid of \eqn{(\alpha, h_\alpha)} values with \eqn{\alpha}
in \eqn{[0.9, 1]}.
}
\examples{
x = subset(faithful, eruptions > 3)
mod = densityMclust(x, plot = FALSE)
out = hypvolgmm_hdlevel(mod$density)
with(out, 
{
  plot(alpha, h_alpha, type = "b", pch = 20)
  lines(alpha[1:pcwsreg$c],
        pcwsreg$a1 * alpha[1:pcwsreg$c] + pcwsreg$b1,
        lty = 2, lwd = 2, col = "red2")
  lines(alpha[pcwsreg$c:length(alpha)],
        pcwsreg$a2 * alpha[pcwsreg$c:length(alpha)] + pcwsreg$b2,
        lty = 2, lwd = 2, col = "red2")
  abline(v = hdl, lty = 3, col = "red2", lwd = 2)
  abline(h = h, lty = 3, col = "red2", lwd = 2)
})

plot(x, xlim = c(2,6), ylim = c(60,100))
surfacePlot(data = mod$data, parameters = mod$parameters,
            what = "density", type = "contour", 
            levels = c(out$h, min(mod$density)),
            xlim = c(2,6), ylim = c(60,100), lty = c(1,2),
            add = TRUE, drawlabels = FALSE)

}
\author{
Luca Scrucca
}
