% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcwr.R
\name{mcwr_genvars}
\alias{mcwr_genvars}
\title{Generate mcwr variables}
\usage{
mcwr_genvars(
  data,
  timing = "",
  add = FALSE,
  replace = FALSE,
  nop = FALSE,
  nor = FALSE,
  order = FALSE
)
}
\arguments{
\item{data}{an mcwr data.frame}

\item{timing}{a character or numeric scalar.
It specifies how rewards are distributed to from and target states. It is
required if option \code{nor} is not used.  timespec can be one of \sQuote{bop}, \sQuote{mid}, and \sQuote{eop}, which stands for
\sQuote{beginning-of-period}, \sQuote{mid-period}, and \sQuote{end-of period}, respectively.  Alternatively, it can also
be a number in the interval [0 1] that specifies the fraction of the interval that goes to the
from-state.  Values of 0, 0.5, and 1 correspond to \sQuote{beginning-of-period}, \sQuote{mid-period}, and
\sQuote{end-of-period}, respectively.}

\item{add}{a boolean TRUE/FALSE. If TRUE, existing r-variables are left unchanged.}

\item{replace}{add a boolean TRUE/FALSE. If TRUE, existing r-variables are replaced.}

\item{nop}{a boolean TRUE/FALSE. If TRUE, not generate any p-variables.
By default, all missing p-variables are generated. Since existing
p-variables must satisfy the sums-to-unity condition, only p-variables that are (by implication)
all-zero can be missing. \code{mcwr_expectancies()} will run whether such redundant variables exist or not.}

\item{nor}{a boolean TRUE/FALSE. If TRUE, does not generate any r-variables.}

\item{order}{a boolean TRUE/FALSE. If TRUE, orders variables alphabetically according to the column list 'age p* r*'.}
}
\value{
A data.frame, suitable for further processing by \code{mcwr_*()} functions.
}
\description{
Generate (additional) transition probability or rewards variables
}
\details{
The main purpose of this function is to generate rewards variables (r-variables).  It examines existing p-
and r-variables, determines the implied full set of states, and generates any missing variables that are
missing from the data frame.  It interacts flexibly with existing r-variables:  You can leave them unchanged or
have them replaced.

An effective way to create r-variables may be to generate a full set of r-variables using \code{mcwr_genvars()} and
then edit them where necessary.  This is illustrated under in the examples section of \link{mcwr}.
}
\seealso{
Other mcwr: 
\code{\link{mcwr_check}()},
\code{\link{mcwr_exit}()},
\code{\link{mcwr_expectancies}()},
\code{\link{mcwr_switch}()}
}
\concept{mcwr}
