% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdir.logrank.R
\name{mdir.logrank}
\alias{mdir.logrank}
\title{Two-sample multiple-direction log rank test}
\usage{
mdir.logrank(data, cross = TRUE, rg = list(c(0, 0)), nperm = 10000,
  dig_p = 3, dig_stat = 3)
}
\arguments{
\item{data}{A data.frame, list or environment containing the variables \code{time},
\code{event} (with values 0 for censored and 1 for uncensored) and \code{group}.}

\item{cross}{logical. Should the weight corresponding to crossing hazards be included?
The default is \code{TRUE}.}

\item{rg}{A list (or \code{NULL}) containing the exponents \code{c(r, g)} of the directions
 \eqn{w(x) = x^r (1-x)^g}. Both exponents r,g need to be natural numbers including 0.
Default is \code{list(c(0, 0))} corresponding to proportional hazards.}

\item{nperm}{The number of permutations used for calculating the permuted p-value.
The default option is 10000.}

\item{dig_p}{The p-values are rounded to \code{dig_p} digits, the default is 3.}

\item{dig_stat}{The test statistic is rounded to \code{dig_stat} digits, the default is 3.}
}
\value{
An  \code{mdirLR} object containing the following components:
\item{Descriptive}{The directions used and whether the directions specified by the user were
   linearly independent.}
 \item{p.values}{The p-values of the multiple-direction logrank test using the
   \eqn{\chi^2}-approximation (Approx.) as well as the one using the permutation approach (Perm.).}
 \item{stat}{Value of the multiple-direction logrank statistic.}
 \item{rg}{A list containing the exponents of the direction considered in the statistical analysis.}
 \item{cross}{logical. Was the crossing direction considered in the statistical analysis?}
 \item{indep}{logical. Were the directions specified by the user linearly independent?}
 \item{nperm}{The number of permutations used for calculating the permuted p-value.}
}
\description{
The mdir.logrank function calculates the multiple-direction logrank
statistic and its corresponding p-values  based on a
\eqn{\chi^2}-approximation and a permutation approach
}
\details{
The package provides the multiple-direction logrank statistic for
  the two sample testing problem within right-censored survival data. Directions
  of the form \eqn{w(x) = 1 - 2x} (\code{cross = TRUE}) and \eqn{w(x) = x^r * (1-x)^g} for natural numbers
  r,g (including 0) can be specified.
  The multiple-direction logrank test needs linearly independent directions.
  A check for this is implemented. If the directions chosen by the user are
  linearly dependent then a subset consisting of linearly independent directions
  is selected automatically.

  The \code{mdir.logrank} function returns the test statistic as well as two
  corresponding p-values: the first is based on a \eqn{chi^2} approximation and
  the second one is based on a permutation procedure.
}
\examples{
library(coin)
data(GTSG)
out <- mdir.logrank(data = GTSG, nperm = 1000)

## Detailed information:
summary(out)

}
\references{
Ditzhaus, M., Friedrich, S. (2018). More powerful logrank
permutation tests for two-sample survival data. arXiv preprint arXiv:1807.05504.
}
\seealso{
\code{\link[mdir.logrank]{mdir.onesided}} (one-sided test)
}
