% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-methods-loglik-array.R
\name{loglik_array}
\alias{loglik_array}
\title{Extract the log-likelihood of an estimated model}
\usage{
loglik_array(model, ...)
}
\arguments{
\item{model}{A \link[=dcm_estimate]{measrdcm} object.}

\item{...}{Unused. For future extensions.}
}
\value{
A "\code{\link[posterior:draws_array]{draws_array}}" object containing the
log-likelihood estimates for the model.
}
\description{
The \code{loglik_array()} methods for \link[=dcm_estimate]{measrdcm} objects
calculates the log-likelihood for an estimated model via the generated
quantities functionality in \emph{Stan} and returns the draws of the \code{log_lik}
parameter.
}
\examples{
\dontshow{if (measr_examples()) withAutoprint(\{ # examplesIf}
rstn_mdm_lcdm <- dcm_estimate(
  dcm_specify(dcmdata::mdm_qmatrix, identifier = "item"),
  data = dcmdata::mdm_data,
  missing = NA,
  identifier = "respondent",
  method = "optim",
  seed = 63277,
  backend = "rstan"
)

loglik_array(rstn_mdm_lcdm)
\dontshow{\}) # examplesIf}
}
