% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphql-introspection.R
\name{meetupr_schema_type}
\alias{meetupr_schema_type}
\title{Get fields for a specific type in the Meetup GraphQL API schema}
\usage{
meetupr_schema_type(type_name, schema = meetupr_schema(), ...)
}
\arguments{
\item{type_name}{The name of the type for which to retrieve fields (e.g.,
"Event", "Group", "Member").}

\item{schema}{The schema object obtained from \code{meetupr_schema()}.}

\item{...}{Additional arguments passed to \code{grepl()} for type name matching
(e.g., \code{ignore.case = TRUE}).}
}
\value{
A tibble with details about the fields:
\describe{
\item{field_name}{Name of the field}
\item{description}{Human-readable description}
\item{type}{GraphQL type of the field}
\item{deprecated}{Logical indicating if field is deprecated}
}
If the type is not found, throws an error. If multiple types match, returns
a tibble of matching type names. If the type has no fields, returns a
message.
}
\description{
This function retrieves detailed information about
all fields available on a
specific GraphQL type. Use this to discover what
data you can query from types
like Event, Group, or Member.
}
\examples{
\dontrun{
# Get all fields on the Event type
event_fields <- meetupr_schema_type("Event")

# Find deprecated fields
event_fields |>
  dplyr::filter(deprecated)

# Pass cached schema to avoid repeated introspection
schema <- meetupr_schema()
group_fields <- meetupr_schema_type("Group", schema = schema)
venue_fields <- meetupr_schema_type("Venue", schema = schema)
}

}
