% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memery.R
\docType{package}
\name{memery}
\alias{memery-package}
\alias{memery}
\title{memery: Internet Memes for Data Analysts}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Generates internet memes that optionally include a superimposed inset plot and other atypical features, combining the visual impact of an attention-grabbing meme with graphic results of data analysis. The package differs from related packages that focus on imitating and reproducing standard memes. Some packages do this by interfacing with online meme generators whereas others achieve this natively. This package takes the latter approach. It does not interface with online meme generators or require any authentication with external websites. It reads images directly from local files or via URL and meme generation is done by the package. While this is similar to the 'meme' package available on CRAN, it differs in that the focus is on allowing for non-standard meme layouts and hybrids of memes mixed with graphs. While this package can be used to make basic memes like an online meme generator would produce, it caters primarily to hybrid graph-meme plots where the meme presentation can be seen as a backdrop highlighting foreground graphs of data analysis results. The package also provides support for an arbitrary number of meme text labels with arbitrary size, position and other attributes rather than restricting to the standard top and/or bottom text placement. This is useful for proper aesthetic interleaving of plots of data between meme image backgrounds and overlain text labels. The package offers a selection of templates for graph placement and appearance with respect to the underlying meme. Graph templates also permit additional template-specific customization. Animated gif support is provided but this is optional and functional only if the 'magick' package is installed. 'magick' is not required unless gif functionality is desired.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/leonawicz/memery}
  \item Report bugs at \url{https://github.com/leonawicz/memery/issues}
}

}
\author{
\strong{Maintainer}: Matthew Leonawicz \email{rpkgs@pm.me}

}
