% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memoria.R
\docType{data}
\name{palaeodataLagged}
\alias{palaeodataLagged}
\title{Lagged data generated by \code{\link{prepareLaggedData}}.}
\format{
dataframe with 19 columns and 3988 rows.
}
\usage{
data(palaeodataLagged)
}
\description{
A dataframe resulting from the application of \code{\link{prepareLaggedData}} to the dataset \code{\link{palaeodata}}. The dataframe columns are named using the pattern \code{VariableName__LagValue}:
}
\details{
\itemize{
  \item \emph{pollen.pinus__0} numeric, values of the response variable (pollen counts of Pinus) at lag 0 (current time). This column is used as the response variable by \code{\link{computeMemory}}.
  \item \emph{pollen.pinus__0.2-1} numeric, time-delayed values of the response for lags 0.2 to 1 (in ky). These columns represent the endogenous ecological memory.
  \item \emph{climate.temperatureAverage__0} numeric, temperature values at lag 0 (concurrent effect).
  \item \emph{climate.rainfallAverage__0} numeric, rainfall values at lag 0 (concurrent effect).
  \item \emph{climate.temperatureAverage__0.2-1} numeric, time-delayed temperature values for lags 0.2 to 1 (exogenous memory).
  \item \emph{climate.rainfallAverage__0.2-1} numeric, time-delayed rainfall values for lags 0.2 to 1 (exogenous memory).
  \item \emph{time} numeric, the time/age column.
}

The dataframe has attributes \code{response} and \code{drivers} that are automatically used by \code{\link{computeMemory}}.
}
\seealso{
Other example_data: 
\code{\link{climate}},
\code{\link{palaeodata}},
\code{\link{palaeodataMemory}},
\code{\link{pollen}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
\concept{example_data}
\keyword{datasets}
