% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_test_cache.R
\name{mnet_test_cache}
\alias{mnet_test_cache}
\title{Create example local mesonet file cache}
\usage{
mnet_test_cache(
  file_cache,
  site_info = FALSE,
  mts_files = FALSE,
  rds_files = FALSE
)
}
\arguments{
\item{file_cache}{an optional character string that provides a path to the
directory to use for the local mesonet file cache. If missing, a new
directory will be created within the temporary directory for the current
session.}

\item{site_info}{a logical value indicating whether to create an example
version of the site_info.csv file in the local file cache}

\item{mts_files}{a logical value indicating whether to create example
versions of Mesonet Time Series (MTS) files in the local file cache}

\item{rds_files}{a logical value indicating whether to create example
versions of processed Mesonet data in the form of R data serialized (RDS)
files in the local file cache}
}
\value{
Invisibly returns the full path to the test file cache
}
\description{
Create an example local mesonet file cache for running tests and examples
}
\examples{

# Create test cache directory and write site info file
test_cache <- mnet_test_cache(site_info = TRUE)

# Create test cache directory and write MTS and RDS files
test_cache <- mnet_test_cache(mts_files = TRUE,
                              rds_files = TRUE)

# Remove test cache directory
unlink(test_cache, recursive = TRUE)

}
