% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SD.R
\name{SD_M_n_pooled_from_groups}
\alias{SD_M_n_pooled_from_groups}
\title{Combined Standard Deviation for Multiple Groups}
\usage{
SD_M_n_pooled_from_groups(M, SD, n)
}
\arguments{
\item{M}{vector of group means}

\item{SD}{vector of group SDs}

\item{n}{vector of group sample sizes}
}
\value{
Within standard deviation
}
\description{
Computes the pooled standard deviation for multiple groups.
}
\details{
This function also returns the combined mean and the total sample size across all groups.
Requires also the mean for all individual groups. If there are only two groups and the mean is not available \code{\link[=SDp_from_SD]{SDp_from_SD()}} can be used instead.
}
\examples{
# Compute the Standard deviation for the following grouped data
M <- c(1, 1.5, 2) # Means
SD <- c(2, 3, 2.5) # SDs
n <- c(72, 80, 55) # sample sizes
SD_M_n_pooled_from_groups(M, SD, n)
}
\references{
\href{https://handbook-5-1.cochrane.org/chapter_7/table_7_7_a_formulae_for_combining_groups.htm}{Cochrane Handbook}

Rücker G, Cates CJ, Schwarzer G. Methods for including information from multi-arm trials in pairwise meta-analysis. Res Synth Methods. 2017 Dec;8(4):392-403. doi: 10.1002/jrsm.1259. Epub 2017 Aug 25. PMID: 28759708.
}
