% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SE.R
\name{SE.SMD_from_SMD}
\alias{SE.SMD_from_SMD}
\title{Standard Error from Sample Sizes and SMD}
\usage{
SE.SMD_from_SMD(SMD, n1, n2, method = "hedges")
}
\arguments{
\item{SMD}{standardized mean differences}

\item{n1}{sample size group 1}

\item{n2}{sample size group 2}

\item{method}{transformation method ("hedges", "cohen")}
}
\value{
Standard error of SMD (e.g. standard error of intervention effect)
}
\description{
Approximates SMD standard error from sample sizes and SMD.
}
\examples{
# SMD = 0.6, sample size group_1 = 50, sample size group_2 = 75
SE.SMD_from_SMD(0.6, 50, 75)
}
\references{
Cooper, H., Hedges, L. V., & Valentine, J. C. (Eds.). (2009). \href{https://psycnet.apa.org/record/2009-05060-000}{Link}
}
