% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMD.R
\name{SMD_from_group}
\alias{SMD_from_group}
\title{Standardized Mean Differences from Group Data}
\usage{
SMD_from_group(M1, M2, SD1, SD2, n1 = NA, n2 = NA, method = "hedges")
}
\arguments{
\item{M1}{treatment effect size group 1}

\item{M2}{treatment effect size group 2}

\item{SD1}{standard deviation group 1}

\item{SD2}{standard deviation group 2}

\item{n1}{sample size group 1}

\item{n2}{sample size group 2}

\item{method}{calculation method ("hedges", "cohen")}
}
\value{
Standardized Mean Differences
}
\description{
Calculates SMD directly from group data. Method "hedges" needs sample size data and returns Hedges' g. Method "cohen" returns Cohen's d.
}
\examples{
# Mean control = 23, Mean intervention = 56, SD control = 30,
#    SD intervention = 35, sample size control = 45, sample size intervention = 60
SMD_from_group(23, 56, 30, 35, 45, 60)
}
\references{
Borenstein, M., Hedges, L.V., Higgins, J.P.T. and Rothstein, H.R. (2009). Converting Among Effect Sizes. In Introduction to Meta-Analysis (eds M. Borenstein, L.V. Hedges, J.P.T. Higgins and H.R. Rothstein). https://doi.org/10.1002/9780470743386.ch7

Hedges L. V., Olkin I. (1985). Statistical methods for meta-analysis. San Diego, CA: Academic Press

Goulet-Pelletier, J.-C., & Cousineau, D. (2018). A review of effect sizes and their confidence intervals, Part 1: The Cohen’s d family. The Quantitative Methods for Psychology, 14(4), 242–265. https://doi.org/10.20982/tqmp.14.4.p242
}
