% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{plotheights.hillsfile3d}
\alias{plotheights.hillsfile3d}
\title{Plot evolution of heights of hills in hillsfile3d object}
\usage{
\method{plotheights}{hillsfile3d}(hills, ignoretime = FALSE, xlab = NULL,
  ylab = NULL, xlim = NULL, ylim = NULL, main = NULL, sub = NULL,
  col = "black", asp = NULL, lwd = 1, axes = TRUE)
}
\arguments{
\item{hills}{hillsfile object.}

\item{ignoretime}{time in the first column of the HILLS file will be ignored.}

\item{xlab}{a title for the x axis: see 'title'.}

\item{ylab}{a title for the y axis: see 'title'.}

\item{xlim}{numeric vector of length 2, giving the x coordinates range.}

\item{ylim}{numeric vector of length 2, giving the y coordinates range.}

\item{main}{an overall title for the plot: see 'title'.}

\item{sub}{a sub title for the plot: see 'title'.}

\item{col}{color code or name, see 'par'.}

\item{asp}{the y/x aspect ratio, see 'plot.window'.}

\item{lwd}{line width for drawing symbols see 'par'.}

\item{axes}{a logical value indicating whether both axes should be drawn
on the plot.}
}
\description{
`plotheights.hillsfile3d` plots evolution of heights of hills. In well tempered
metadynamics hill heights decrees with flooding of the free energy surface.
Evolution of heights may be useful to evaluate convergence of the simulation.
}
\examples{
plotheights(acealanme3d)
}
