% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ricker.R
\name{ricker}
\alias{ricker}
\title{A simple Ricker model}
\usage{
ricker(spawners, a, b)
}
\arguments{
\item{spawners}{Spawner abundance}

\item{a}{Ricker productivity parameter. Recruits are e^a at the origin.}

\item{b}{Ricker density dependent parameter.}
}
\value{
Returns the number of recruits.
}
\description{
A simple Ricker model
}
\examples{
S <- seq(100, 1000, length.out = 100)
R <- ricker(S, a = 1.9, b = 900)
plot(S, R)
}
