% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{scale_vast}
\alias{scale_vast}
\title{Scale intensities of features using vast scaling}
\usage{
scale_vast(data)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}
}
\value{
A tibble with vast scaled intensities.
}
\description{
Scales the intensities of all features using

\deqn{\widetilde{x}_{ij}=\frac{x_{ij}-\overline{x}_{i}}{s_i}\cdot \frac{\overline{x}_{i}}{s_i}}

where \eqn{\widetilde{x}_{ij}} is the intensity of sample \eqn{j}, feature \eqn{i} after scaling,
\eqn{x_{ij}} is the intensity of sample \eqn{j}, feature \eqn{i} before scaling, \eqn{\overline{x}_{i}} is the mean of intensities of feature \eqn{i} across all samples
and \eqn{{s_i}} is the standard deviation of intensities of feature \eqn{i} across all samples. Note that \eqn{\frac{\overline{x}_{i}}{s_i} = \frac{{1}}{CV}} where CV is the coefficient of variation across all samples.
\code{\link[metamorphr]{scale_vast_grouped}} is a variation of this function that uses a group-specific coefficient of variation.
In other words, it performs autoscaling (\code{\link[metamorphr]{scale_auto}}) and divides by the coefficient of variation, thereby reducing the importance of features with a poor reproducibility.
}
\examples{
toy_metaboscape \%>\%
  scale_vast()
}
\references{
\itemize{
\item R. A. Van Den Berg, H. C. Hoefsloot, J. A. Westerhuis, A. K. Smilde, M. J. Van Der Werf, \emph{BMC Genomics} \strong{2006}, \emph{7}, 142, DOI 10.1186/1471-2164-7-142.
\item J. Sun, Y. Xia, \emph{Genes & Diseases} \strong{2024}, \emph{11}, 100979, DOI 10.1016/j.gendis.2023.04.018.
}
}
