% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_sample.R
\name{utils_samples}
\alias{utils_samples}
\alias{sample_random}
\alias{sample_systematic}
\title{Random Sampling}
\usage{
sample_random(data, n, prop, by = NULL, weight = NULL)

sample_systematic(data, n, r = NULL, by = NULL)
}
\arguments{
\item{data}{A data frame. If \code{data} is a \code{grouped_df}, the operation will be
performed on each group (stratified).}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used.}

\item{by}{A categorical variable to compute the sample by. It is a
shortcut to \code{\link[dplyr:group_by]{dplyr::group_by()}} that allows to group the data by one
categorical variable. If more than one grouping variable needs to be used,
use \code{\link[dplyr:group_by]{dplyr::group_by()}} to pass the data grouped.}

\item{weight}{Sampling weights. This must evaluate to a vector of
non-negative numbers the same length as the input. Weights are
automatically standardised to sum to 1.}

\item{r}{The starting element. By default, \code{r} is randomly selected between
\code{1:k}}
}
\value{
An object of the same type as \code{data}.
}
\description{
\itemize{
\item \code{\link[=sample_random]{sample_random()}} performs Simple Random Sampling or Stratified Random
Sampling
\item \code{\link[=sample_systematic]{sample_systematic()}} performs systematic sampling. In this case, a regular
interval of size k (\code{k = floor(N/n)}) is generated considering the population
size (N) and desired sample size (n). Then, the starting member (\code{r}) is
randomly chosen between \code{1-k}. The second element is \code{r} + \code{k}, and so on.
}
}
\examples{
library(metan)
sample_random(data_ge, n = 5)
sample_random(data_ge,
              n = 3,
              by = ENV)

sample_systematic(data_g, n = 6)
}
