% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.mean.R
\name{est.sld.q1q2q3}
\alias{est.sld.q1q2q3}
\title{Estimating Unknown Parameters using First Quartile, Median and Third Quartile}
\usage{
est.sld.q1q2q3(
   q1 = NULL, 
   med = NULL, 
   q3 = NULL, 
   n = NULL, 
   opt = TRUE
   )
}
\arguments{
\item{q1}{numeric value representing the first quartile of the sample.}

\item{med}{numeric value representing the median of the sample.}

\item{q3}{numeric value representing the third quartile of the sample.}

\item{n}{numeric value specifying the sample size.}

\item{opt}{logical value indicating whether to apply the optimisation step in estimating parameters using theoretical quantiles.
The default value is \code{TRUE}.}
}
\value{
A list with following components:
\itemize{
\item \code{parameters}: named numeric vector representing the estimated parameters ('location', 'scale', 'skewing') of SLD.
\item \code{mean}: numeric value of the estimated mean of the sample using SLD.
\item \code{sd}: numeric value of the estimated standard deviation of the sample using SLD.
}
}
\description{
This function provide estimates for the parameters of skew logistic distribution (SLD), the sample mean and the standard deviation using 3-number summary \{first quartile (\eqn{q_1}), median (\eqn{q_2}), third quartile (\eqn{q_3})\} from a study with sample size \eqn{n},
using the method explained in De Livera et al. (2024).
}
\details{
De Livera et al. (2024) proposed using the skew logistic distribution (SLD) to estimate unknown parameters for studies reporting 3-number summaries in the meta-analysis context.

The quantile-based skew logistic distribution, introduced by Gilchrist (2000) and further modified by van Staden and King (2015)
is used to approximate the sample's distribution using 3-point summaries.
The SLD quantile function is defined using three parameters: a location parameter (\eqn{\lambda}), a scale parameter (\eqn{\eta}), and a skewing parameter (\eqn{\delta}).
The parameters of the SLD are estimated by formulating and solving a set of simultaneous equations which relate the estimated sample quantiles to their theoretical counterparts of the SLD.
}
\examples{
#Generate 3-number summary data
set.seed(123)
n <- 1000
x <- stats::rlnorm(n, 4, 0.3)
quants <- c(stats::quantile(x, probs = c(0.25, 0.5, 0.75)))

#Estimate SLD parameters using 3-number summary
params<- est.sld.q1q2q3(q1 = quants[1], med = quants[2], q3 = quants[3], 
                            n=n, opt=TRUE)$parameters
params

}
\references{
De Livera, A. M., Prendergast, L., & Kumaranathunga, U. (2024). A novel density-based approach for estimating unknown means, distribution visualisations and meta-analyses of quantiles. \emph{arXiv preprint arXiv:2411.10971}. \url{https://arxiv.org/abs/2411.10971}.

Gilchrist, W. (2000). \emph{Statistical modelling with quantile functions}. Chapman & Hall/CRC.

van Staden, P. J., & King, R. A. R. (2015). The quantile-based skew logistic distribution. \emph{Statistics & Probability Letters, 96}, 109–116.

King, R., & van Staden, P. (2022). sld: Estimation and use of the Quantile-Based Skew Logistic Distribution (R package Version 1.0.1). Comprehensive R Archive Network (CRAN). https://doi.org/10.32614/CRAN.package.sld. \url{https://CRAN.R-project.org/package=sld}.#'
}
\seealso{
\code{\link[=est.gld.five]{est.gld.five()}}, \code{\link[=est.sld.minq2max]{est.sld.minq2max()}}
}
