% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_variables_from}
\alias{get_variables_from}
\title{Get variables info}
\usage{
get_variables_from(service = c("meteocat"), options)
}
\arguments{
\item{service}{Character with the service name (in lower case).}

\item{options}{List with the needed service options. See \code{\link{services_options}} to have more info
about the different services and their options.}
}
\value{
A data frame with the variables info
}
\description{
Obtain information about variables as offered by the APIs
}
\details{
Depending on the service, information about original variable names,
menaning, original units...
\strong{Currently only MeteoCat is available}, other services will result
in an error
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
  library(meteospain)
  library(keyring)

  # MeteoCat (we need a key)
  # key_set('meteocat')
  api_options <- meteocat_options("daily", api_key = key_get('meteocat'))
  get_variables_from('meteocat', api_options)
\dontshow{\}) # examplesIf}
}
