% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmwp_p_p_ind.R
\name{bmwp_p_p_ind}
\alias{bmwp_p_p_ind}
\title{BMWP prime prime index}
\usage{
bmwp_p_p_ind(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating if progress messages should be given.}
}
\value{
This function returns a list with the following components:
\item{Ibmwp_p_p_n}{The numerical BMWP’’ index (Loyola, 2000).}
\item{Ibmwp_p_p_c}{The BMWP’’ water quality classes (Loyola, 2000).}
}
\description{
Calculate Biological Monitoring Working Party (BMWP) prime prime index (Loyola, 2000)
}
\details{
The new BMWP’’ is an adaptation of the BMWP (Armitage et al. 1983) for the lotic environments of the Paraná River. This adaptation was based on the observation of the occurrence of the important families in the rivers in the region. Some families were added by ecological equivalence and others by similarity in the level of tolerance to contamination. The scores assigned to the different families were not changed (Loyola, 2000).
}
\examples{

#Load example data
example_data

#Run bmwp_p_p_ind with that example_data
bmwpp<-bmwp_p_p_ind(example_data)

#Check results
bmwpp$Ibmwp_p_p_n
bmwpp$Ibmwp_p_p_c
}
\references{
Armitage PD, Moss D, Wright JF & Furse MT (1983). The performance of a new biological water quality score system based on macroinvertebrates over a wide range of unpolluted running-water sites. \doi{10.1016/0043-1354(83)90188-4}

Loyola RGN (2000). Atual estágio do IAP no uso de índices biológicos de qualidade. Bioindicadores qualidade aguas \url{https://www.iat.pr.gov.br/sites/agua-terra/arquivos_restritos/files/documento/2021-03/bioindicadores_qualidade_aguas_2001_2002.pdf}
}
\seealso{
\link[metrix]{read_data}, \link{bmwp_ind}, \link{bmwp_p_ind}, \link{biotic_ind}
}
\author{
Juan Manuel Cabrera and Julieta Capeletti.
}
