% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tol_metrics.R
\name{tol_metrics}
\alias{tol_metrics}
\title{Tolerance metrics}
\usage{
tol_metrics(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating if progress messages should be given.}
}
\value{
This function returns a data.frame with all the calculated tolerance measures.:
\item{r_oligochir}{Oligochaeta/Chironomidae.}
\item{r_oligoset}{Oligochaeta with setaform chaetae/Oligochaeta without setaform chaetae.}
\item{r_tanychir}{Tanytarsini/Chironomidae.}
\item{den_t_lhoff}{\emph{Limnodrilus hoffmeisteri}/Total density.}
\item{den_t_bothr}{\emph{Bothrioneurum}/Total density.}
\item{den_t_tubi}{\emph{Tubifex}/Total density.}
\item{den_t_dero}{\emph{Dero}/Total density.}
\item{den_t_prist}{\emph{Pristina}/Total density.}
\item{den_t_chiro}{\emph{Chironomus}/Total density.}
}
\description{
Indicate sensitivity of the assemblage and component species to various types of disturbance.
}
\details{
Most of the metrics applied in the study of macroinvertebrates use as a key factor the tolerance or intolerance of the different taxa to a certain disturbance, normally organic contamination. The relationship between the number of organisms that are tolerant and intolerant to contamination is a common resource in the metrics used. Further metrics (multimetric indexes) can be derived from a combination of these primary metrics (Prat et al., 2009). The \emph{Limnodrilus hoffmeisteri}/total density ratio, which was developed by Marchese & Ezcurra de Drago (1999), increases in environments with organic contamination.
}
\examples{
#Load example data
example_data

#Run tol_metrics with that example_data
tolmetrics<-tol_metrics(example_data)

#Check results
tolmetrics
}
\references{
Marchese M & Ezcurra de Drago I (1999). Use of benthic macroinvertebrates as organic pollution indicators in lotic environments of the Parana River drainage basin. \url{https://agro.icm.edu.pl/agro/element/bwmeta1.element.agro-article-e981d07b-e469-4460-a7fe-3239650cd089}

Prat N, Ríos B, Acosta R & Rieradevall M (2009). Los macroinvertebrados como indicadores de calidad de las aguas. \url{http://www.ub.edu/riosandes/docs/MacroIndLatinAmcompag0908.pdf}
}
\seealso{
\link[metrix]{read_data}
}
\author{
Juan Manuel Cabrera and Julieta Capeletti.
}
