% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rail-position.R
\name{rail_positions}
\alias{rail_positions}
\title{Live Train Positions}
\format{
A tibble with 1 row per train and 9 variables:
\describe{
\item{TrainId}{Uniquely identifiable internal train identifier.}
\item{TrainNumber}{\emph{Non-unique} train identifier, often used by WMATA's
Rail Scheduling and Operations Teams, as well as over open radio
communication.}
\item{CarCount}{Number of cars. Can sometimes be 0 when there is no data
available.}
\item{DirectionNum}{The direction of movement regardless of which track the
train is on. Valid values are 1 or 2. Generally speaking, trains with
direction 1 are northbound/eastbound, while trains with direction 2 are
southbound/westbound.}
\item{CircuitId}{The circuit identifier the train is currently on. This
identifier can be referenced from the Standard Routes method.}
\item{DestinationStationCode}{Destination station code. Can be \code{NA}. Use
this value in other rail-related APIs to retrieve data about a station.
Note that this value may \emph{sometimes} differ from the destination station
code returned by our Next Trains methods.}
\item{LineCode}{Two-letter abbreviation for the line (e.g.: RD, BL, YL, OR,
GR, or SV). May also be \code{NA} in certain cases.}
\item{SecondsAtLocation}{Approximate "dwell time". This is not an exact
value, but can be used to determine how long a train has been reported at
the same track circuit.}
\item{ServiceType}{Service Type of a train, can be any of the following
Service Types:
\itemize{
\item \code{NoPassengers}: This is a non-revenue train with no passengers on board.
Note that this designation of \code{NoPassengers} does not necessarily
correlate with PIDS "No Passengers". As of 08/22/2016, this functionality
has been reinstated to include all non-revenue vehicles, with minor
exceptions.
\item \code{Normal}: This is a normal revenue service train.
\item \code{Special}: This is a special revenue service train with an unspecified
line and destination. This is more prevalent during scheduled track
work.
\item \code{Unknown}: This often denotes cases with unknown data or work vehicles.
}
}
}
}
\usage{
rail_positions(api_key = wmata_key())
}
\arguments{
\item{api_key}{Subscription key which provides access to this API. Defaults
\code{Sys.getenv("WMATA_KEY")} via \code{\link[=wmata_key]{wmata_key()}}.}
}
\value{
A data frame of train positions.
}
\description{
Returns uniquely identifiable trains in service and what track circuits they
currently occupy. Will return an empty set of results when no positions are
available.
}
\details{
Please refer to \href{https://developer.wmata.com/TrainPositionsFAQ}{this page}
for additional details.
}
\examples{
\dontrun{
rail_positions()
}
}
\seealso{
\url{https://developer.wmata.com/docs/services/5763fa6ff91823096cac1057/operations/5763fb35f91823096cac1058}

Other Train Positions: 
\code{\link{standard_routes}()},
\code{\link{track_circuits}()}
}
\concept{Train Positions}
