% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_daily_synop.R,
%   R/download_monthly_synop.R
\name{download_daily_synop}
\alias{download_daily_synop}
\alias{download_monthly_synop}
\title{Download Meteo France Synop Data}
\usage{
download_daily_synop(path = ".", date, ...)

download_monthly_synop(path = ".", date, ...)
}
\arguments{
\item{path}{character. Data once downloaded are saved in the folder 
\code{file.path(path, "data-raw")}.}

\item{date}{character. 
For \code{download_daily_synop}, a date in the form 
\code{"YYYYMMDDHH"}. 
For \code{download_monthly_synop}, a date in the form 
\code{"YYYYMM"}.}

\item{...}{Additional parameters to be passed to \code{\link[utils]{download.file}}.}
}
\description{
The functions \code{download_daily_synop} and 
\code{download_monthly_synop} enable to download Meteo France 
Synop Data described 
\href{https://donneespubliques.meteofrance.fr/?fond=produit&id_produit=90&id_rubrique=32}{here}.
}
\seealso{
\code{\link[metsyn]{make_metsyn}}.
}
