% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extgp.R
\name{thselect.egp}
\alias{thselect.egp}
\title{Threshold selection based on extended generalized Pareto models}
\usage{
thselect.egp(
  xdat,
  thresh,
  model = c("pt-beta", "pt-gamma", "pt-power", "gj-tnorm", "gj-beta", "exptilt",
    "logist"),
  type = c("wald", "lrt"),
  level = 0.95,
  transform = FALSE,
  plot = FALSE,
  ...
)
}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{model}{a string indicating which extended family to fit}

\item{type}{choice of test statistic, either \code{wald} for Wald-based intervals, or \code{lrt} for profile likelihood ratio test.}

\item{level}{[double] confidence interval level, default to 0.95.}

\item{transform}{logical; if \code{TRUE} and \code{type="wald"}, intervals for \code{kappa} are computed on the log-scale and back-transformed.}

\item{plot}{[logical] if \code{TRUE}, return a plot of p-values against threshold}

\item{...}{additional arguments, passed to plotting routine}
}
\value{
an invisible list of class \code{mev_thselect_egp} with elements
\itemize{
\item{\code{thresh}:} vector of threshold candidates
\item{\code{thresh0}:} selected threshold among candidates
\item{\code{coef}:}  vector of parameter estimates for \eqn{\kappa}
\item{\code{stat}:} squared version of the test statistic
\item{\code{pval}:} p-value obtained from the  \eqn{\chi^2_1} approximation
\item{\code{level}:} level of the confidence intervals
\item{\code{model}:} string giving the EGP model family
\item{\code{type}:} type of confidence interval
}
}
\description{
Fit an EGP model to data over a range of candidate thresholds \code{thresh} and perform likelihood-based tests of equality for \eqn{\kappa=c}, where \eqn{c=1} for all regular models and $\eqn{c=0} for the \code{'gj-tnorm'} and \code{'logist'} models, for which the generalized Pareto special case corresponds to a value of \eqn{\kappa} occuring on the boundary of the parameter space.
}
\details{
The threshold selection procedure returns chi-square statistics (\code{stat}) for Wald or profile likelihood ratio tests, along with p-values (\code{pval}) obtained from large sample distribution. The threshold returned is the lowest for which all further higher thresholds fail to reject the null hypothesis of \eqn{\kappa=c}, or equivalently of generalized Pareto tail.
}
\examples{
ths <- thselect.egp(
  xdat = rexp(1000),
  thresh = qexp(c(0.8,0.9,0.95)),
  model = "pt-power")
print(ths)
plot(ths)
}
