% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pickands.R
\name{thselect.ksmd}
\alias{thselect.ksmd}
\title{Mahalanobis distance-based methodology}
\usage{
thselect.ksmd(xdat, thresh, approx = c("asymptotic", "mc"), nsim = 1000L)
}
\arguments{
\item{xdat}{[numeric] vector of observations}

\item{thresh}{[numeric] vector of candidate thresholds. If missing, 20 sample quantiles starting at the 0.25 quantile in increments of 3.75 percent.}

\item{approx}{[string] method to use to obtain moments of first L-moment}

\item{nsim}{[integer] number of replications for Monte Carlo approximation}
}
\value{
a list with components
\itemize{
\item \code{thresh0}: selected threshold returned by the procedure
\item \code{thresh}: vector of candidate thresholds
\item \code{pval}: scalar \emph{p}-value for the chi-square approximation to the test statistic for the selected threshold
\item \code{dist}: vector of Mahalanobis distance
\item \code{approx}: type of approximation
}
}
\description{
Compute the Mahalanobis distance-based threshold method over a grid of thresholds by
transforming data from generalized Pareto to unit exponential based on probability weighted moment estimates,
then computing the first L-moment and the L-skewness. The latter are compared to the
theoretical counterparts from a unit exponential sample of the same size, which is used to compute
the Mahalanobis distance. The threshold returned is the one which minimizes the distance.
}
\references{
Kiran, K. G. and Srivinas, V.V. (2021). \emph{A Mahalanobis distance-based automatic threshold selection method for peaks over threshold model.} Water Resources Research 57. <doi:10.1029/2020WR027534>
}
