% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mfp.R
\name{order_variables}
\alias{order_variables}
\alias{order_variables_by_significance}
\title{Helper to order variables for mfp2 algorithm}
\usage{
order_variables(xorder = "ascending", x = NULL, ...)

order_variables_by_significance(
  xorder,
  x,
  y,
  family,
  weights,
  offset,
  strata,
  method,
  control,
  nocenter
)
}
\arguments{
\item{xorder}{a string determining the order of entry of the covariates
into the model-selection algorithm. The default is \code{ascending}, which enters
them by ascending p-values, or decreasing order of significance in a
multiple regression (i.e. most significant first).
\code{descending} places them in reverse significance order, whereas
\code{original} respects the original order in \code{x}.}

\item{x}{a design matrix of dimension n * p where n is the number of
observations and p the number of predictors including intercept for glms,
or excluding intercept for Cox models.}

\item{...}{passed to \code{order_variables_by_significance}.}

\item{y}{a vector of responses for glms, or a \code{Surv} object generated using
the \code{\link[survival:Surv]{survival::Surv()}} function for Cox models.}

\item{family}{a character string naming a family function supported by
\code{glm()} or "cox" for Cox models.}

\item{weights, offset}{parameters for both glm and Cox models, see either
\code{\link[stats:glm]{stats::glm()}} or \code{\link[survival:coxph]{survival::coxph()}} depending on family.}

\item{strata, method, control, nocenter}{Cox model specific parameters, see
\code{\link[survival:coxph]{survival::coxph()}}.}
}
\value{
A vector of the variable names in \code{x}, ordered according to \code{xorder}.
}
\description{
To be used in \code{\link[=fit_mfp]{fit_mfp()}}.
}
\section{Functions}{
\itemize{
\item \code{order_variables_by_significance()}: Order by significance in regression model. The
number of columns of \code{x} should be greater than 1 for Cox models.

}}
