% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfp_step.R
\name{transform_data_step}
\alias{transform_data_step}
\title{Function to extract and transform adjustment variables}
\usage{
transform_data_step(x, xi, powers_current, df, powers, acdx)
}
\arguments{
\item{x}{a matrix of predictors that includes the variable of interest \code{xi}.
It is assumed that continuous variables have already been shifted and scaled.}

\item{xi}{name of the continuous predictor for which the FP function will be
estimated. There are no binary or two-level variables allowed. All variables
except \code{xi} are referred to as "adjustment variables".}

\item{powers_current}{a named list of FP powers of all variables of interest,
including \code{xi}. Note that these powers are updated during backfitting or MFP
cycles.}

\item{df}{a numeric vector of degrees of freedom for \code{xi}.}

\item{powers}{a set of allowed FP powers.}

\item{acdx}{a logical vector indicating the use of acd transformation.}
}
\value{
A list containing the following elements:
\itemize{
\item \code{powers_fp}: fp powers used for \code{data_fp}.
\item \code{data_fp}: a list with all possible fp transformations for \code{xi}, see the
\code{data} component of the output of \code{\link[=generate_transformations_fp]{generate_transformations_fp()}} and
\code{\link[=generate_transformations_acd]{generate_transformations_acd()}}.
\item \code{powers_adj}: fp powers for adjustment variables in \code{data_adj}.
\item \code{data_adj}: adjustment data, i.e. transformed input data for adjustment
variables.
}
}
\description{
Function to extract and transform adjustment variables
}
\details{
After extracting the adjustment variables this function, using their
corresponding FP powers stored in \code{powers_current}, transforms them.
This is necessary When evaluating x of interest, as we must account for other
variables, which can be transformed or untransformed, depending on the
individual powers. It's worth noting that some powers can be NA, indicating
that the variable has been left out of the adjustment variables. It also
returns the FP data, which is dependent on the degrees of freedom. For example,
\code{df = 2} is equivalent to FP degree one, resulting in the generation of 8
variables. If \code{acdx} for the current variables of interest is set to \code{TRUE},
however, 64 variables are generated.

When \code{df = 1}, this function returns data unchanged, i.e. a "linear"
transformation with power equal to 1. In case \code{acdx[xi] = TRUE}, the
acd transformation is applied.
}
