% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrStat.R
\name{discr.stat}
\alias{discr.stat}
\title{Discriminability Statistic}
\usage{
discr.stat(
  X,
  Y,
  is.dist = FALSE,
  dist.xfm = mgc.distance,
  dist.params = list(method = "euclidean"),
  dist.return = NULL,
  remove.isolates = TRUE
)
}
\arguments{
\item{X}{is interpreted as:
\describe{
   \item{a \code{[n x d]} data matrix}{X is a data matrix with \code{n} samples in \code{d} dimensions, if flag \code{is.dist=FALSE}.}
   \item{a \code{[n x n]} distance matrix}{X is a distance matrix. Use flag \code{is.dist=TRUE}.}
}}

\item{Y}{\code{[n]} a vector containing the sample ids for our \code{n} samples.}

\item{is.dist}{a boolean indicating whether your \code{X} input is a distance matrix or not. Defaults to \code{FALSE}.}

\item{dist.xfm}{if \code{is.dist == FALSE}, a distance function to transform \code{X}. If a distance function is passed,
it should accept an \code{[n x d]} matrix of \code{n} samples in \code{d} dimensions and return a \code{[n x n]} distance matrix,
which can be either the default output, an item castable to a distance matrix, or . See \link[mgc]{mgc.distance} for details.}

\item{dist.params}{a list of trailing arguments to pass to the distance function specified in \code{dist.xfm}.
Defaults to \code{list(method='euclidean')}.}

\item{dist.return}{the return argument for the specified \code{dist.xfm} containing the distance matrix. Defaults to \code{FALSE}.
\describe{
    \item{\code{is.null(dist.return)}}{use the return argument directly from \code{dist.xfm} as the distance matrix. Should be an object castable to a \code{[n x n]} matrix.
    You can verify whether this is the case by looking at \code{as.matrix(do.call(dist.xfm, list(X, <trailing_args>))}}
    \item{\code{is.character(dist.return) | is.integer(dist.return)}}{use \code{dist.xfm[[dist.return]]} as the distance matrix. Should be a \code{[n x n]} matrix.}
}}

\item{remove.isolates}{remove isolated samples from the dataset. Isolated samples are samples with only
one instance of their class appearing in the \code{Y} vector. Defaults to \code{TRUE}.}
}
\value{
A list containing the following:
\item{\code{discr}}{the discriminability statistic.}
\item{\code{rdf}}{the rdfs for each sample.}
}
\description{
A function for computing the discriminability from a distance matrix and a set of associated labels.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("discriminability", package = "mgc")}
}

\examples{
sim <- discr.sims.linear(100, 10, K=2)
X <- sim$X; Y <- sim$Y
discr.stat(X, Y)$discr

}
\references{
Eric W. Bridgeford, et al. "Optimal Decisions for Reference Pipelines and Datasets: Applications in Connectomics." Bioarxiv (2019).
}
\author{
Eric Bridgeford
}
