% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswalks.R
\name{read_symbol_to_id_map}
\alias{read_symbol_to_id_map}
\title{Read marker symbol to identifier mappings}
\usage{
read_symbol_to_id_map(report_file = NULL, n_max = Inf)
}
\arguments{
\item{report_file}{The path to a MRK_List1.rpt file. Leave this as \code{NULL}
and the function will automatically download the report from
\url{https://www.informatics.jax.org/downloads/reports/MRK_List1.rpt}.}

\item{n_max}{Maximum number of lines to read.}
}
\value{
A \link[data.table:data.table]{data.table} where each row is a mapping,
from \code{marker_symbol} to \code{marker_id_now}:
\itemize{
\item \code{marker_symbol} (set as key): marker symbol is a unique abbreviation of the marker name.
\item \code{marker_id_now}: genetic marker identifier replacement. If the record pertains a  \code{marker_symbol} that was withdrawn, then \code{marker_id_now} indicates the most recent in-use marker identifier that replaced it.
}
}
\description{
\code{\link[=read_symbol_to_id_map]{read_symbol_to_id_map()}} reads MRK_List1.rpt data and returns an efficient
data table to be used for marker symbol remapping to marker identifiers. Note
that old symbols will be remapped to new symbols' ids, if applicable.

This function is memoised.
}
\keyword{internal}
