% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_mhcnuggets_installation.R
\name{check_mhcnuggets_installation}
\alias{check_mhcnuggets_installation}
\title{Check if MHCnuggets is installed.}
\usage{
check_mhcnuggets_installation(
  folder_name = get_default_mhcnuggets_folder(),
  mhcnuggets_url = get_mhcnuggets_url()
)
}
\arguments{
\item{folder_name}{superfolder of MHCnuggets.
The name of the superfolder is \code{/home/[user_name]/.local/share}
by default, as can be obtained by\link{get_default_mhcnuggets_folder}}

\item{mhcnuggets_url}{URL to the MHCnuggets GitHub repository}
}
\value{
Nothing.
}
\description{
Check if MHCnuggets is installed. Will \link{stop} if not.
}
\details{
An MHCnuggets installation has two parts:
\enumerate{
\item The installation of the Python package,
for running the code
\item The download of the Python source code,
which allows the use of example files
}
}
\examples{
if (is_mhcnuggets_installed()) {
  check_mhcnuggets_installation()
}
}
\author{
Richèl J.C. Bilderbeek
}
