#' Full text of the \emph{Renert} in Luxembourguish
#'
#' A dataset containing the full text of Michel Rodange's
#' epic, \emph{Renert oder de Fuuß am Frack an a Ma'nsgrëßt} in
#' Luxembourguish.
#'
#' @format A data frame with 6471 rows and 3 variables:
#' \describe{
#'   \item{\code{line}}{Original text}
#'   \item{\code{gesank}}{\emph{Song}; the text is subdivided in songs, called \emph{gesank} in Luxembourguish}
#'   \item{\code{nb_line}}{Line number}
#' }
#' @source \url{https://data.public.lu/fr/datasets/the-works-in-luxembourguish-of-michel-rodange/}
"renert"

#' Full text of the \emph{Sigfrid} play in Luxembourguish
#'
#' A dataset containing the full text of Michel Rodange's
#' play, \emph{Dem Grow Sigfrid seng Goldkuommer} in
#' Luxembourguish.
#'
#' @format A data frame with 6471 rows and 3 variables:
#' \describe{
#'   \item{\code{line}}{Original text}
#'   \item{\code{act}}{Section of the play}
#'   \item{\code{nb_line}}{Line number}
#' }
#' @source \url{https://data.public.lu/fr/datasets/the-works-in-luxembourguish-of-michel-rodange/}
"sigfrid"

#' Full text of the \emph{D'Léierchen} poem in Luxembourguish
#'
#' A dataset containing the full text of Michel Rodange's
#' poem, \emph{D'Léierchen, Dem Léiweckerche säi Lidd} in
#' Luxembourguish.
#'
#' @format A data frame with 6471 rows and 3 variables:
#' \describe{
#'   \item{\code{line}}{Original text}
#'   \item{\code{nb_line}}{Line number}
#' }
#' @source \url{https://data.public.lu/fr/datasets/the-works-in-luxembourguish-of-michel-rodange/}
"dleierchen"