% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_well_positions.R
\name{check_well_positions}
\alias{check_well_positions}
\alias{check_monotonicity}
\title{Check monotonicity of well positions across groups}
\usage{
check_well_positions(
  input_data,
  x_var = "Timepoint",
  y_var = "Value",
  grouping = "Position",
  v_var = "Validity",
  wp_var = "Position"
)

check_monotonicity(vec)
}
\arguments{
\item{input_data}{A data.frame containing the input data, e.g. from a function call to
\code{tidy_single_plate}, \code{tidy_plates_via_params} or \code{tidy_plates_via_prompts}.}

\item{x_var}{A character string specifying the variable to be plotted on the x-axis. Defaults to
'Timepoint'.}

\item{y_var}{A character string specifying the variable to be plotted on the y-axis. Defaults to
'Value'.}

\item{grouping}{A vector of character strings specifying the grouping variables.
Defaults to 'Position' if no grouping is provided.}

\item{v_var}{A character string specifying the validity information. Usually a column
with all rows being 'valid'. Rows are set to 'invalid' based on user selection. Defaults to
"Validity".}

\item{wp_var}{A character string specifying the column providing the well positions. Defaults to
"Position".}

\item{vec}{A numeric vector to be checked for monotonicity.}
}
\value{
\code{check_well_positions} returns a subset of the input data containing
only the data from non-monotonic groups, if non-monotonic groups are detected.
Otherwise, NULL is returned.

\code{check_monotonicity} returns a logical value.
}
\description{
\code{check_well_positions} checks if well positions across groups, i.e.
experiments, monotonically increase or decrease with timepoints measured.

\code{check_monotonicity} checks whether the values in a numeric vector are monotonically
increasing or decreasing.
}
\details{
If non-monotonic groups of well positions are detected, \code{check_well_positions}
plots them as line graphs and returns a list with both the corresponding subset of the data for
further inspection and the input data adjusted for invalid well positions from visual inspection.

\code{check_monotonicity} checks if all differences between consecutive elements 
in the vector 'vec' are non-negative (indicating monotonic non-decreasing 
behavior) or non-positive (indicating monotonic non-increasing behavior).
}
\examples{
# Generate example data
set.seed(123)
df <- data.frame(Position = rep(1:21, 2),
                 Value = c(1:21, sample(1:21,21, TRUE)),
                 Timepoint = rep(paste0("T",1:3),14),
                 Validity = "valid",
                 Group_1 = rep(LETTERS[1:2], each=21),
                 Group_2 = rep(letters[1:14], each = 3))
# All groups behave monotonically
check_well_positions(df[df$Group_1 == "A",],
                     x_var = "Timepoint",
                     y_var = "Value",
                     grouping = c("Group_1", "Group_2"))
# Six groups behave non-monotonically
check_well_positions(df[df$Group_1 == "B",],
                     x_var = "Timepoint",
                     y_var = "Value",
                     grouping = c("Group_1", "Group_2"))
# Check if a vector is monotonically increasing (will return TRUE)
check_monotonicity(c(1, 2, 3, 4, 5))
# Check if a vector is monotonically decreasing (will return FALSE)
check_monotonicity(c(5, 80, 3, 2, 1))
}
\seealso{
\code{tidy_plate}, \code{tidy_plates_via_params}, \code{tidy_plates_via_prompts}

\code{\link{validate_cells}}, \code{\link{update_validity}}
}
