% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibreg.R
\name{weibreg}
\alias{weibreg}
\alias{gres}
\alias{scoretest.weibreg}
\title{Weibull regression model for duration data}
\usage{
weibreg(
  formula,
  data,
  weights,
  subset,
  na.action,
  offset,
  contrasts = NULL,
  model = c("aft", "ph"),
  opt = c("bfgs", "newton", "nr"),
  start = NULL,
  maxit = 100,
  robust = TRUE,
  trace = 0,
  mixing = FALSE,
  check_gradient = FALSE,
  ...
)

gres(x)

\method{scoretest}{weibreg}(object, ..., vcov = NULL)
}
\arguments{
\item{formula}{a symbolic description of the model}

\item{data}{a data frame}

\item{subset, weights, na.action, offset, contrasts}{see \code{stats::lm},}

\item{model}{one of \code{"aft"} or \code{"ph"}}

\item{opt}{the optimization method}

\item{start}{a vector of starting values}

\item{maxit}{maximum number of iterations}

\item{robust}{a boolean if \code{TRUE}, the log of the shape and the
variance parameters are estimated}

\item{trace}{an integer}

\item{mixing}{if \code{TRUE}, the Gamma-Weibull model is estimated}

\item{check_gradient}{if \code{TRUE} the numeric gradient and hessian
are computed and compared to the analytical gradient and
hessian}

\item{...}{further arguments}

\item{x, object}{a \code{weibreg} object}

\item{vcov}{the covariance matrix estimator to use for the score
test}
}
\value{
an object of class \code{c("weibreg", "micsr")}, see
\code{micsr::micsr} for further details.
}
\description{
The Weibull model is the most popular model for duration data. This
function enables the estimation of this model with two alternative
(but equivalent) parametrization: the Accelerate Failure Time and
the Proportional Hazard. Moreover heterogeneity can be introduced,
which leads to the Gamma-Weibull model
}
\examples{
library(survival)
wz <- weibreg(Surv(duration, censored == "no") ~ gender + age + log(wage + 1),
         unemp_duration, mixing = TRUE, model = "ph")
}
\keyword{models}
