% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cylinder-bundle-geometry.R
\name{plot3d}
\alias{plot3d}
\title{Plots a 3D representation of a cylinder bundle using \strong{plotly}}
\usage{
plot3d(b, show_linear_mesh = FALSE)
}
\arguments{
\item{b}{An object of class \code{bundle} as generated by
\code{\link[=simulate_bundle]{simulate_bundle()}}.}

\item{show_linear_mesh}{A logical value indicating whether the linear mesh of
each cylinder should be displayed. Defaults to \code{FALSE} for computational
efficiency.}
}
\value{
An HTML widget of class \code{\link[plotly:plotly]{plotly::plotly}} storing the 3D
visualization of the cylinder bundle.
}
\description{
Plots a 3D representation of a cylinder bundle from an object of class
\code{bundle} as generated by \code{\link[=simulate_bundle]{simulate_bundle()}} using
\href{https://plotly.com/r/}{\strong{plotly}}.
}
\examples{
density <- 0.5
voxel_size <- 5 # micrometers
withr::with_seed(1234, {
  out <- simulate_bundle(density, voxel_size)
})
plot3d(out)
}
