## Compare Function
utils::globalVariables(c("x"))

#' Compares posterior distributions from different reports
#'
#' @param R1 object produced by miebl_re; start from highest performance criterion to lowest
#' @param R2 object produced by miebl_re
#' @param R3 object produced by miebl_re
#' @param R4 object produced by miebl_re
#' @param R5 object produced by miebl_re
#'
#' @return a combined plot of the posterior distributions for each performance criterion
#' @export
#'
#' @examples
#' #create a miebl output for default 90% desired true mastery
#' xx<-miebl(10)
#' #Uses the miebl output for miebl_re for 90% and 80% performance criterion
#' r1<-miebl_re(xx,mc=90)
#' r2<-miebl_re(xx,mc=80)
#' miebl_cp(r1,r2)

miebl_cp<-function(R1,R2,R3=NULL,R4=NULL, R5=NULL){
  curve(R1[[3]](x),ylab="Density",xlab="True Mastery")
  curve(R2[[3]](x),add=TRUE,col="red")

  lg<-c(R1[[1]][1],R2[[1]][1])
  cl<-c("black","red")

  if(!is.null(R3)){
    curve(R3[[3]](x),add=TRUE,col="blue")
    lg<-c(R1[[1]][1],R2[[1]][1],R3[[1]][1])
    cl<-c("black","red","blue")

    }

  if(!is.null(R4)){
    curve(R4[[3]](x),add=TRUE,col="green")
    lg<-c(R1[[1]][1],R2[[1]][1],R3[[1]][1],R4[[1]][1])
    cl<-c("black","red","blue","green")

  }

  if(!is.null(R5)){
    curve(R5[[3]](x),add=TRUE,col="pink")
    lg<-c(R1[[1]][1],R2[[1]][1],R3[[1]][1],R4[[1]][1],R5[[1]][1])
    cl<-c("black","red","blue","green","pink")
  }


  legend(x = "topleft", box.lwd = 0, bg = "transparent", box.col = "transparent",
         legend=lg,
         fill = cl)



}
