% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical.R
\name{dtellipt}
\alias{dtellipt}
\title{Density of elliptical vectors subject to a linear constraint}
\usage{
dtellipt(x, beta, mu, sigma, df, delta = 0, log = FALSE)
}
\arguments{
\item{beta}{\code{d} vector of linear constraints}

\item{mu}{location vector}

\item{sigma}{scale matrix}

\item{df}{degrees of freedom argument}

\item{delta}{buffer; default to zero}

\item{log}{logical; if \code{TRUE}, return the log density}
}
\value{
an \code{n} by \code{d} matrix of random vectors
}
\description{
Compute the density of multivariate Student-t or Gaussian \eqn{\boldsymbol{x}}
with location vector \code{mu}, scale matrix \code{sigma} and  \code{df} (integer) degrees of freedom
subject to the linear constraint \eqn{\boldsymbol{\beta}^\top\boldsymbol{x} > \delta}.
Negative degrees of freedom or values larger than 1000 imply Gaussian vectors are generated instead.
}
\keyword{internal}
