% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{train_model}
\alias{train_model}
\title{Train model using \code{\link[caret:train]{caret::train()}}.}
\usage{
train_model(
  train_data,
  outcome_colname,
  method,
  cv,
  perf_metric_name,
  tune_grid,
  ...
)
}
\arguments{
\item{train_data}{Training data. Expected to be a subset of the full dataset.}

\item{outcome_colname}{Column name as a string of the outcome variable
(default \code{NULL}; the first column will be chosen automatically).}

\item{method}{ML method. Options: \code{c("glmnet", "rf", "rpart2", "svmRadial", "xgbTree")}.
\itemize{
\item glmnet: linear, logistic, or multiclass regression
\item rf: random forest
\item rpart2: decision tree
\item svmRadial: support vector machine
\item xgbTree: xgboost
}}

\item{cv}{Cross-validation caret scheme from \code{define_cv()}.}

\item{perf_metric_name}{The column name from the output of the function
provided to perf_metric_function that is to be used as the performance
metric. Defaults: binary classification = \code{"ROC"}, multi-class
classification = \code{"logLoss"}, regression = \code{"RMSE"}.}

\item{tune_grid}{Tuning grid from \code{get_tuning_grid()}.#'}

\item{...}{All additional arguments are passed on to \code{caret::train()}, such
as case weights via the \code{weights} argument or \code{ntree} for \code{rf} models. See
the \code{caret::train()} docs for more details.}
}
\value{
Trained model from \code{\link[caret:train]{caret::train()}}.
}
\description{
Train model using \code{\link[caret:train]{caret::train()}}.
}
\examples{
\dontrun{
training_data <- otu_mini_bin_results_glmnet$trained_model$trainingData \%>\%
  dplyr::rename(dx = .outcome)
method <- "rf"
hyperparameters <- get_hyperparams_list(otu_mini_bin, method)
cross_val <- define_cv(training_data,
  "dx",
  hyperparameters,
  perf_metric_function = caret::multiClassSummary,
  class_probs = TRUE,
  cv_times = 2
)
tune_grid <- get_tuning_grid(hyperparameters, method)

rf_model <- train_model(
  training_data,
  "dx",
  method,
  cross_val,
  "AUC",
  tune_grid,
  ntree = 1000
)
rf_model$results \%>\% dplyr::select(mtry, AUC, prAUC)
}
}
\author{
Zena Lapp, \email{zenalapp@umich.edu}
}
