% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toy_data.R
\name{lnm_data}
\alias{lnm_data}
\title{Simulates data from a Logistic Normal Multinomial Model.}
\usage{
lnm_data(N = 100, D = 5, K = 10)
}
\arguments{
\item{N}{The number of samples in the output data.}

\item{D}{The number of covariates, each of which can influence the response
composition vector (e.g., the timepoint or disease status).}

\item{K}{The number of output dimensions (e.g., number of taxa).}
}
\value{
A list with the following components:
\describe{
\item{X}{An N x D matrix of covariates.}
\item{y}{The N x K simulated samples.}
\item{B}{The D x K relationship between covariates and outputs.}
}
}
\description{
Simulates data from a Logistic Normal Multinomial Model.
}
\examples{
lnm_data(5, 3, 3)
}
