% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{predict,lnm-method}
\alias{predict,lnm-method}
\title{LNM Fitted Probabilities}
\usage{
\S4method{predict}{lnm}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class lnm with fitted parameters \eqn{\hat{B}} and
which we want to use to form predictions on new samples.}

\item{newdata}{New samples on which to form predictions. Defaults to NULL, in
which case predictions are made at the same design points as those used
during the original training.}

\item{...}{Additional keyword arguments, for consistency with R's predict
generic (never used).}
}
\value{
A matrix with predictions along rows and outcomes along columns. Rows
sum up to one.
}
\description{
Given an input dataset, predict the output composition. Specifically, this
outputs \eqn{\phi^{-1}(Bx)}, for the inverse log ratio transformation
\eqn{\phi^{-1}} and fitted covariate matrix \eqn{B}.
}
\examples{
example_data <- lnm_data(N = 50, K = 10)
xy <- dplyr::bind_cols(example_data[c("X", "y")])
fit <- lnm(
    starts_with("y") ~ starts_with("x"), xy, 
    iter = 25, output_samples = 25
)
head(predict(fit))
}
