\name{minque-package}
\alias{minque-package}
\alias{minque}
\docType{package}
\title{
Various Linear Mixed Model Analyses

}
\description{
This package offers three important components: (1) to construct a use-defined linear mixed model, (2) to employ one of linear mixed model approaches: minimum norm quadratic unbiased estimation (MINQUE) (Rao, 1971) for variance component estimation and random effect prediction;(3) to employ a jackknife resampling technique to conduct various statistical tests; and (4) to conduct various model evaluations. This R package offers fast computations for large data sets analyses for various irregular data structures.
}
\details{
\tabular{ll}{
Package: \tab minque\cr
Type: \tab Package\cr
Version: \tab 2.0\cr
Date: \tab 2019-12-18\cr
License: \tab GPL-3\cr
}
 An overview of how to use the package, including the most important functions
}
\author{
Jixiang Wu, Associate Professor of Quantitative Genetics/Biostatistics,
\\Jixiang Wu <jixiang.wu@sdstate.edu>

}
\references{

Miller, R. G. 1974. The jackknife - a review. Biometrika, 61:1- 15.

Patterson, H. D. and Thompson, R. 1971. Recovery of inter-block information when block sizes are unequal. Biometrika, 58: 545-554.

Rao, C.R. 1971. Estimation of variance and covariance components-MINQUE theory. J Multiva Ana 1:19

Rao, C. R. and Kleffe, J. 1980. Estimation of variance components. In Handbook of Statistics. Vol. l: 1-40. Krishnaiah, P. R. ed. New York. North-Holland.

Searle, S. R., Casella, G. and McCulloch, C. E. 1992. Variance Components. John Wiley & Sons, Inc. New York.

Wu J (2012) GenMod: An R package for various agricultural data analyses.  ASA, CSSA, and SSSA 2012 International Annual Meetings, Cincinnati, OH, p 127

Wu J., Bondalapati K., Glover K., Berzonsky W., Jenkins J.N., McCarty J.C. 2013. Genetic analysis without replications: model evaluation and application in spring wheat. Euphytica. 190:447-458

Zhu J. 1989. Estimation of Genetic Variance Components in the General Mixed Model. Ph.D. Dissertation, NC State University, Raleigh, U.S.A

Zhu J. 1993. Methods of predicting genotype value and heterosis for offspring of hybrids. (Chinese). Journal of Biomathematics, 8(1): 32-44
}

\keyword{ MINQUE }
\keyword{ Linear mixed model }
\keyword{ Jackknife }
\keyword{ REML }

